using System;
using System.Data;
using System.Data.SqlClient;
using System.Transactions;
using System.Collections.Generic;
using System.Text;

namespace NestedImplicit
{
   class Program
   {
      static SqlConnection conn;

      static void Main(string[] args)
      {
         try
         {
            using (TransactionScope scope = new TransactionScope())
            {
               using (conn = new SqlConnection(
                 "data source=localhost; initial catalog=SampleDB;integrated security=SSPI;"))
               {
                  conn.Open();
                  for (int x = 1; x < 8; x++)
                  {
                     DeleteCustomer(x);
                  }
               }
               scope.Complete();
            }
         }

         catch (TransactionAbortedException)
         {
            Console.WriteLine(
              "Jeden lub wicej blokw potomnych zgosio przerwanie wykonywania transakcji.");
         }

         Console.ReadLine();
      }

      static void DeleteCustomer(int custId)
      {
         using (TransactionScope scope = new TransactionScope())
         {
            SqlCommand cmd = conn.CreateCommand();
            cmd.CommandText = "DELETE Customers WHERE ID = " + custId.ToString();
            cmd.ExecuteNonQuery();

            if (custId < 7)
               scope.Complete();
         }
      }
   }
}
